; Copyright (c) 2013, M@T
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
;     * Redistributions of source code must retain the above copyright
;       notice, this list of conditions and the following disclaimer.
;     * Redistributions in binary form must reproduce the above copyright
;       notice, this list of conditions and the following disclaimer in the
;       documentation and/or other materials provided with the distribution.
;     * Neither the name of the <organization> nor the
;       names of its contributors may be used to endorse or promote products
;       derived from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL M@T BE LIABLE FOR ANY
; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
; ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;
; Programme ARM-Thumb permettant de patcher la ROM de distribution de Victini pour afficher une image de fond.
; S'utilise avec ARMIPS (de Kingcom): http://aerie.wingdreams.net/
; Il faut avoir extrait les fichiers "arm7.bin" et "arm9.bin" de la ROM au pralable


.nds

.open arm7.bin,0x2380000	; Ouvre le fichier "arm7.bin"

.org 0x23A6370
displaybg:			; Routine affichant l'image de fond
push r0,r1,r2,r14	; Sauvegarde les registres

ldr  r0,=bg			; Charge l'adresse des donnes de l'image dans r0
mov  r1,0x6000000	; Adresse de la VRAM
mov  r14,0x6000		; Nombre d'itrations (256*192/2 parce qu'on copie 2 pixels  chaque fois)

displaybgloop:		; Dbut de boucle
ldr  r2,[r0],4		; Charge 2 pixels dans r2,  partir des donnes de l'image (1 pixel utilise 2 octets -> on charge 4 octets, donc 2 pixels)
str  r2,[r1],4		; crit ces 2 pixels dans la VRAM pour les afficher  l'cran
subs r14,r14,1		; Dcrmente r14
bgt  displaybgloop	; Tant que r14 > 0, on boucle

pop  r0,r1,r2,r15	; Restaure les registres prcdemment sauvegards

.pool				; "Pool" de constantes
bg:
.fill 0x18000,0x80	; Initialise l'image avec des pixels de couleur vert moche (mais osef, c'est la faon la plus simple de procder, on va pas faire les difficiles)

.close	; Ferme le fichier "arm7.bin"


.open arm9.bin,0x2000000	; Ouvre le fichier "arm9.bin"

.org 0x20011EC
bl displaybg	; Excute la routine d'affichage de l'image de fond

.close	; Ferme le fichier "arm9.bin"
